<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('timeslots_translations')) {
            Schema::create('timeslots_translations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('timeslot_id')->default(0);
                $table->foreign('timeslot_id')->references('id')->on('timeslots')->onDelete('cascade');
                $table->string('lang_code', 10);
                $table->string('name', 255)->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('timeslots_translations');
    }
};
