<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('product_translations')) {
            Schema::create('product_translations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('product_id')->default(0);
                $table->string('lang_code', 255);
                $table->string('name', 255)->nullable();
                $table->text('description')->nullable();
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');

                // Indexes
                $table->index('lang_code');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_translations');
    }
};
