<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('partners_translations')) {
            Schema::create('partners_translations', function (Blueprint $table) {
                $table->id();
                $table->string('lang_code', 10);
                $table->string('name', 255);
                $table->unsignedBigInteger('partner_id');
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('partner_id')->references('id')->on('partners')->onDelete('cascade');

                // Indexes
                $table->index('lang_code');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partners_translations');
    }
};
