<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('order_cancel_request')) {
            Schema::create('order_cancel_request', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('order_id')->default(0);
                $table->double('refund_amount', 8, 2)->nullable();
                $table->unsignedBigInteger('refund_status')->default(0);
                $table->unsignedBigInteger('status')->default(0);
                $table->timestamps();

                // Indexes
                $table->index('user_id');
                $table->index('order_id');

                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_cancel_request');
    }
};
