<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('orders_products_delivery')) { 
            Schema::create('orders_products_delivery', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('order_id')->default(0);
                $table->integer('driver_id')->nullable()->default(NULL);
                $table->unsignedBigInteger('product_order_id')->default(0);
                $table->unsignedBigInteger('product_id')->default(0);
                $table->dateTime('delivery_date')->nullable();
                $table->unsignedBigInteger('order_status_id')->default(0);
                $table->timestamps();

                // Indexes
                $table->index('user_id');
                $table->index('order_id');
                $table->index('driver_id');
                $table->index('product_order_id');
                $table->index('product_id');
                $table->index('order_status_id');

                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
                $table->foreign('product_order_id')->references('id')->on('orders_products')->onDelete('cascade');
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
                $table->foreign('order_status_id')->references('id')->on('order_statuses');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders_products_delivery');
    }
};
