<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('orders_products')) { 
            Schema::create('orders_products', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('order_id')->nullable();
                $table->unsignedBigInteger('product_id')->default(0);
                $table->integer('quantity')->unsigned()->default(0);
                $table->double('per_item_amount', 8, 2)->default(0.00);
                $table->double('per_delivery_amount', 8, 2)->default(0.00);
                $table->double('total_delivery_amount', 8, 2)->default(0.00);
                $table->unsignedBigInteger('no_of_delivery')->nullable();
                $table->enum('order_frequency', ['daily', 'weekly', 'monthly', 'once', 'alternative'])
                      ->collation('utf8mb4_unicode_ci')->default('once');
                $table->string('days', 255)->collation('utf8mb4_unicode_ci')->nullable();
                $table->date('start_date')->nullable();
                $table->date('end_date')->nullable();
                $table->timestamps();

                // Indexes
                $table->index('user_id');
                $table->index('order_id');
                $table->index('product_id');

                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders_products');
    }
};
