<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('notifications')) { 
            Schema::create('notifications', function (Blueprint $table) {
                $table->id();
                $table->string('lang_code', 5)->collation('utf8mb4_unicode_ci')->nullable();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('order_id')->default(0);
                $table->string('image', 255)->collation('utf8mb4_unicode_ci')->nullable();
                $table->string('title', 255)->collation('utf8mb4_unicode_ci')->nullable();
                $table->string('message', 255)->collation('utf8mb4_unicode_ci')->nullable();
                $table->integer('read_status')->default(0);
                $table->timestamps();

                // Indexes
                $table->index('user_id');

                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
