<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('orders')) {
            Schema::create('orders', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('order_status_id')->default(0);
                $table->unsignedBigInteger('delivery_address_id')->default(0);
                $table->unsignedBigInteger('payment_id')->nullable()->default(NULL);
                $table->string('payment_transection_id', 255)->nullable();
                $table->longText('payment_transection_data')->nullable();
                $table->string('payment_refferance_id', 255)->nullable();
                $table->tinyInteger('payment_status')->default(0)->comment('0=processing, 1=success, 2=failed, 3=canceled');
                $table->double('promotional_disount', 8, 2)->default(0.00);
                $table->integer('is_coupon_applied')->nullable();
                $table->string('coupon_code', 60)->collation('utf8_bin')->nullable();
                $table->double('subtotal', 8, 2)->default(0.00);
                $table->double('final_amount', 8, 2)->default(0.00);
                $table->double('tax', 8, 2)->default(0.00);
                $table->double('delivery_fee', 8, 2)->default(0.00);
                $table->string('payment_method', 255)->collation('utf8_bin')->nullable();
                $table->unsignedBigInteger('timeslot_id')->nullable();
                $table->timestamps();

                // Indexes
                $table->index('user_id');
                $table->index('order_status_id');
                $table->index('delivery_address_id');
                $table->index('payment_id');
                $table->index('timeslot_id');

                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('order_status_id')->references('id')->on('order_statuses');
                $table->foreign('delivery_address_id')->references('id')->on('delivery_addresses');
                $table->foreign('payment_id')->references('id')->on('user_payments')->onDelete('set null'); // Add onDelete('set null')
                $table->foreign('timeslot_id')->references('id')->on('timeslots');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
