<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('keyword_translations')) {
            Schema::create('keyword_translations', function (Blueprint $table) {
                $table->id();
                $table->string('lang_code', 5)->collation('utf8mb4_unicode_ci');
                $table->string('group', 191)->nullable()->collation('utf8mb4_unicode_ci');
                $table->text('keyword')->collation('utf8mb4_unicode_ci');
                $table->text('value')->nullable()->collation('utf8mb4_unicode_ci');
                $table->timestamps();

                // Indexing columns
                $table->index('lang_code');
                $table->index('group');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('keyword_translations');
    }
};
