<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('languages')) { 
            Schema::create('languages', function (Blueprint $table) {
                $table->id();
                $table->string('language_name', 191)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('language_code', 191)->collation('utf8mb4_unicode_ci');
                $table->enum('language_direction', ['ltr', 'rtl'])->default('ltr')->collation('utf8mb4_unicode_ci');
                $table->integer('status')->default(1);
                $table->enum('is_default', ['1', '0'])->default('0')->collation('utf8mb4_unicode_ci');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('languages');
    }
};
