<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
 public function up()
    {
        if (!Schema::hasTable('failed_jobs')) {
            Schema::create('failed_jobs', function (Blueprint $table) {
                $table->id();
                $table->string('uuid', 255)->collation('utf8mb4_unicode_ci');
                $table->text('connection')->collation('utf8mb4_unicode_ci');
                $table->text('queue')->collation('utf8mb4_unicode_ci');
                $table->longText('payload')->collation('utf8mb4_unicode_ci');
                $table->longText('exception')->collation('utf8mb4_unicode_ci');
                $table->timestamp('failed_at')->useCurrent();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('failed_jobs');
    }
};
