<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('delivery_areas')) {
            Schema::create('delivery_areas', function (Blueprint $table) {
                $table->id();
                $table->string('location_name', 255)->nullable();
                $table->integer('zip_code')->nullable();
                $table->unsignedBigInteger('state_id')->default(0);
                $table->unsignedBigInteger('city_id')->default(0);
                $table->string('country', 217)->nullable();
                $table->string('city', 217)->nullable();
                $table->string('region', 217)->nullable();
                $table->string('latitude', 50)->nullable();
                $table->string('longitude', 50)->nullable();
                $table->integer('status')->default(1);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_areas');
    }
};
