<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('delivery_addresses')) {
            Schema::create('delivery_addresses', function (Blueprint $table) {
                $table->id();
                $table->string('type', 150)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('location_name', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('address', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('google_address', 255)->nullable()->collation('utf8_bin');
                $table->text('note')->nullable()->collation('utf8_bin');
                $table->string('city', 255)->nullable()->collation('utf8_bin');
                $table->string('state', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('country', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('zipcode', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('latitude', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->string('longitude', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->tinyInteger('is_default')->default(0);
                $table->unsignedBigInteger('user_id')->default(0);
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_addresses');
    }
};
