<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('currencies')) {
            Schema::create('currencies', function (Blueprint $table) {
                $table->id();
                $table->string('name', 127)->collation('utf8_bin');
                $table->string('symbol', 63)->collation('utf8mb4_unicode_ci');
                $table->string('code', 5)->collation('utf8mb4_unicode_ci');
                $table->tinyInteger('decimal_digits')->unsigned()->nullable();
                $table->tinyInteger('rounding')->unsigned()->nullable();
                $table->tinyInteger('status')->default(1);
                $table->enum('is_default', ['1', '0'])->default('0')->collation('utf8mb4_unicode_ci');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currencies');
    }
};
