<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
    {
        if (!Schema::hasTable('coupon_translations')) {  
            Schema::create('coupon_translations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('coupon_id')->default(0);
                $table->string('coupon_name', 127)->collation('utf8_bin');
                $table->string('lang_code', 5)->collation('utf8mb4_unicode_ci');
                $table->text('description')->nullable()->collation('utf8mb4_unicode_ci');
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupon_translations');
    }

};
