<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('coupons')) { 
            Schema::create('coupons', function (Blueprint $table) {
                $table->id();
                $table->string('coupon_name', 127)->collation('utf8_bin');
                $table->string('image', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->enum('type', ['Fixed', 'Percent'])->collation('utf8mb4_unicode_ci');
                $table->double('value');
                $table->date('start_date');
                $table->date('end_date');
                $table->text('description')->nullable()->collation('utf8mb4_unicode_ci');
                $table->double('minimum_order_value', 8, 2)->default(0.00);
                $table->integer('status')->default(1);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
};
