<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
       public function up()
    {
        if (!Schema::hasTable('contactus')) { 
            Schema::create('contactus', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->default(0);
                $table->string('name', 150)->collation('utf8mb4_unicode_ci')->nullable();
                $table->string('email', 191)->collation('utf8mb4_unicode_ci')->nullable();
                $table->string('mobile', 25)->collation('utf8mb4_unicode_ci')->nullable();
                $table->text('message')->collation('utf8mb4_unicode_ci')->nullable();
                $table->integer('is_replied')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contactus');
    }
};
