<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('cms_content_translations')) { 
            Schema::create('cms_content_translations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('cms_id')->default(0);
                $table->string('lang_code', 10)->collation('utf8mb4_unicode_ci');
                $table->text('page_title')->collation('utf8mb4_unicode_ci')->nullable();
                $table->text('description')->collation('utf8mb4_unicode_ci')->nullable();
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('cms_id')->references('id')->on('cms_contents')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cms_content_translations');
    }
};
