<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('carts')) {
            Schema::create('carts', function (Blueprint $table) {
                $table->id();
                $table->unsignedInteger('user_id')->default(0);
                $table->unsignedInteger('product_id')->default(0);
                $table->unsignedInteger('quantity')->default(0);
                $table->float('per_item_amount', 8, 2)->default(0.00);
                $table->float('per_delivery_amount', 8, 2)->default(0.00);
                $table->float('total_delivery_amount', 8, 2)->default(0.00);
                $table->unsignedInteger('no_of_delivery')->nullable();
                $table->text('delivery_dates')->nullable();
                $table->enum('order_frequency', ['daily', 'weekly', 'monthly', 'once', 'alternative'])->default('once');
                $table->string('days', 255)->nullable();
                $table->date('start_date')->nullable();
                $table->date('end_date')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
};
