<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
    {
        if (!Schema::hasTable('banner_translations')) {
            Schema::create('banner_translations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('banner_id')->default(0);
                $table->string('lang_code', 5)->collation('utf8mb4_unicode_ci');
                $table->string('title', 191)->collation('utf8_bin');
                $table->string('sub_title', 255)->nullable()->collation('utf8mb4_unicode_ci');
                $table->timestamps();

                // Foreign key constraint
                $table->foreign('banner_id')->references('id')->on('banners')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banner_translations');
    }
};
