<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
      public function up()
    {
        if (!Schema::hasTable('products')) {
            Schema::create('products', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name', 255);
                $table->string('image', 255)->nullable();
                $table->double('price', 8, 2)->default(0.00);
                $table->double('discount_price', 8, 2)->default(0.00)->nullable();
                $table->double('stock', 8, 2)->default(0.00);
                $table->text('description')->nullable();
                $table->integer('minimum_order_quantity')->default(0);
                $table->tinyInteger('status')->default(1);
                $table->timestamps();
                $table->softDeletes();

                // Indexes
                // Add additional indexes if needed
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
