<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        if (!Schema::hasTable('user_payments')) {
            Schema::create('user_payments', function (Blueprint $table) {
                $table->id();
                $table->double('price', 8, 2)->default(0.00);
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->index();
                $table->string('payment_transection_id', 256)->nullable();
                $table->longText('payment_transection_data')->nullable();
                $table->string('payment_refferance_id', 256)->nullable();
                $table->tinyInteger('payment_status')->default(0)->comment('0=processing, 1=success, 2=failed, 3=canceled');
                $table->string('status')->nullable();
                $table->string('method')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_payments');
    }
};
