<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->enum('type', ['admin', 'user', 'driver', 'subadmin'])->default('user');
                $table->string('language_code')->nullable();
                $table->string('lang_code')->nullable();
                $table->string('name');
                $table->string('image')->nullable();
                $table->string('email')->nullable();
                $table->string('password')->nullable();
                $table->string('phone', 25)->unique()->nullable();
                $table->string('country_code', 5)->default('+91');
                $table->tinyInteger('status')->default(1);
                $table->tinyInteger('is_verified')->default(1);
                $table->tinyInteger('enable_notification')->default(1);
                $table->integer('otp')->nullable();
                $table->integer('role_id')->default(0);
                $table->string('remember_token', 100)->nullable();
                $table->text('fcm_token')->nullable();
                $table->timestamp('email_verified_at')->nullable();
                $table->timestamps();
                $table->softDeletes();

                // Indexes
                $table->index('type');
                $table->index('language_code');
                $table->index('name');
                $table->index('email');
                $table->index('phone');
                $table->index('otp');
                $table->index('role_id');
                $table->index('email_verified_at');
                $table->index('status');
                $table->index('created_at');
                $table->index('updated_at');
            });
        } else {
            // If the table exists, only add the column if it doesn't exist
            if (!Schema::hasColumn('users', 'country_code')) {
                Schema::table('users', function (Blueprint $table) {
                    $table->string('country_code', 5)->default('+91')->after('phone');
                });
            }
             // Check and add 'lang_code' if it doesn't exist
            if (!Schema::hasColumn('users', 'lang_code')) {
                Schema::table('users', function (Blueprint $table) {
                    $table->string('lang_code')->nullable()->after('type');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
