<?php

/*
 * This file is part of the Laravel Rave package.
 *
 * (c) Oluwole Adebiyi - Flamez <flamekeed@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
use App\Models\AppSetting;

return [

    /**
     * Public Key: Your Rave publicKey. Sign up on https://dashboard.flutterwave.com/ to get one from your settings page
     *
     */
    'publicKey' => '',

    /**
     * Secret Key: Your Rave secretKey. Sign up on https://dashboard.flutterwave.com/ to get one from your settings page
     *
     */
    'secretKey' =>  '',

    /**
     * Prefix: Secret hash for webhook
     *
     */
    'secretHash' =>  '',

    'flutterwaveSupportedCurrencies' => [
        'GBP', // British Pound Sterling
        'CAD', // Canadian Dollar
        'XAF', // Central African CFA Franc
        'CLP', // Chilean Peso
        'COP', // Colombian Peso
        'EGP', // Egyptian Pound
        'EUR', // SEPA (Euro)
        'GHS', // Ghanaian Cedi
        'GNF', // Guinean Franc
        'KES', // Kenyan Shilling
        'MWK', // Malawian Kwacha
        'MAD', // Moroccan Dirham
        'NGN', // Nigerian Naira
        'RWF', // Rwandan Franc
        'SLL', // Sierra Leonean Leone
        'STD', // São Tomé and Príncipe dobra
        'ZAR', // South African Rand
        'TZS', // Tanzanian Shilling
        'UGX', // Ugandan Shilling
        'USD', // United States Dollar
        'XOF', // West African CFA Franc BCEAO
        'ZMW'  // Zambian Kwacha
    ],

];
