<?php

namespace App\Services;

use LiqPay;

class LiqPayService
{
    protected $liqpay;

    public function __construct()
    {
        $this->liqpay = new LiqPay(setting('liqpay_public_key'), setting('liqpay_private_key'));
    }

     public function createPayment(array $params): string
    {
        return $this->liqpay->cnb_form([
            'version'    => '3',
            'action'     => 'pay',
            'amount'     => $params['amount'],
            'currency'   => $params['currency'],
            'description'=> $params['description'],
            'order_id'   => $params['order_id'],
            'result_url' => route('liqpay.callback'), // callback route
            'server_url' => route('liqpay.server.callback'), // server-to-server callback
        ]);
    }
}
