<?php

namespace App\Notifications\Channels;

use Illuminate\Notifications\Notification;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification as FcmNotification;
use Kreait\Firebase\Factory;

class FirebaseChannel
{
    protected $messaging;

    public function __construct()
    {
        $this->messaging = (new Factory)
            ->withServiceAccount(storage_path('/app/firebase_credentials.json')) // Update with your JSON file path
            ->createMessaging();
    }

    public function send($notifiable, Notification $notification)
    {
        // Fetch the token from the notifiable entity
        $token = $notifiable->routeNotificationFor('fcm');

        if (!$token) {
            return;
        }

        // Create FCM Notification using the Laravel Notification
        $messageData = $notification->toFcm($notifiable);

        $notification = FcmNotification::create($messageData['title'], $messageData['body']);

        // Construct the Cloud Message
        $message = CloudMessage::withTarget('token', $token)
            ->withNotification($notification)
            ->withData($messageData['data'] ?? []);

        // Send the notification
        try {
            $this->messaging->send($message);
        } catch (\Exception $e) {
            // Log the error if sending failed
            \Log::error("Failed to send FCM notification: " . $e->getMessage());
        }
    }
}
