<?php

namespace App\Providers;

use Illuminate\Support\Facades\Schema;
use App\Models\Languages;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\QueryException;

class LanguageServiceProvider extends ServiceProvider
{
    public function boot()
    {
        try {
            // Check if the database connection is available
            if (Schema::hasTable('languages')) {
                // If the table exists, retrieve language data
                $languages = Languages::where('status',1)->pluck('language_name', 'language_code')->toArray();
                config(['languages' => $languages]);
            } else {
                // If the table doesn't exist, provide a fallback or handle accordingly
                config(['languages' => []]);
            }
        } catch (QueryException $e) {
            // Handle the exception if the database connection is not available
            // You can log the error, use a fallback, or take any other appropriate action
            config(['languages' => []]);
        }
    }

    public function register()
    {
        // ...
    }
}
