<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Kreait\Firebase\Factory;

class FirebaseServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('firebase', function ($app) {
            // Path to your Firebase service account JSON file
            $serviceAccountPath = storage_path('app/firebase-credentials.json'); // Update this path accordingly
            $databaseUri = 'https://waterapp-787d2-default-rtdb.firebaseio.com/'; // Update with your database URI

            return (new Factory)
                ->withServiceAccount($serviceAccountPath)
                ->withDatabaseUri($databaseUri);
        });
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
