<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use App\Notifications\Channels\FirebaseChannel;

class FcmNotification extends Notification
{
    protected $title;
    protected $body;
    protected $data;
    protected $tokens; // Add tokens property

    public function __construct($title, $body, $data = [], $tokens = [])
    {
        $this->title = $title;
        $this->body = $body;
        $this->data = $data;
        $this->tokens = $tokens; // Initialize tokens
    }

    public function via($notifiable)
    {
        return ['fcm']; // Use the custom FCM channel
    }

    public function toFcm($notifiable)
    {
        return [
            'title' => $this->title,
            'body' => $this->body,
            'data' => $this->data,
            'tokens' => $this->tokens, // Add tokens to payload
        ];
    }

}
