<?php

namespace App\Notifications\Channels;

use App\Models\AppSetting;
use Illuminate\Notifications\Notification;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification as FcmNotification;
use Kreait\Firebase\Factory;
use Storage;

class FirebaseChannel
{
    protected $messaging;

    public function __construct()
    {
        $this->messaging = (new Factory)
            ->withServiceAccount(Storage::path('/public/firebase/firebase_credentials.json')) // Update with your JSON file path
            ->createMessaging();
    }

    public function send($notifiable, Notification $notification)
    {
        // Fetch the tokens from the notifiable entity
        $tokens = $notifiable->routeNotificationFor('fcm');
        $enableFirebaseNotifications = AppSetting::get_setting('is_enable_firebase_notification',null);
        $enableFirebase = AppSetting::get_setting('is_enable_firebase',null);
        if (empty($tokens)) {
            return;
        }

        // Create FCM Notification using the Laravel Notification
        $messageData = $notification->toFcm($notifiable);
        // Create an instance of FcmNotification
        $fcmNotification = FcmNotification::create($messageData['title'], $messageData['body']);

        // Send the notification to multiple tokens
        foreach ($tokens as $token) {
            try {
                // Create a new CloudMessage instance for each token
                $message = CloudMessage::new()
                    ->withTarget('token', $token)
                    ->withNotification($fcmNotification)
                    ->withData($messageData['data'] ?? []);

                // Check if Firebase notification setting is enabled
                if ($enableFirebase && $enableFirebaseNotifications) {
                    // Send the notification
                    $this->messaging->send($message);
                } else {
                    // Log or handle the case where notifications are disabled
                    \Log::info("Firebase notifications are disabled. Skipping message sending to token {$token}.");
                }
            } catch (\Exception $e) {
                // Log the error if sending failed
                \Log::error("Failed to send FCM notification to token {$token}: " . $e->getMessage());
            }
        }
    }

}
