<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWallet extends Model
{
    use HasFactory;

    public $table = 'user_wallets';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'type',
        'amount',
        'description'
    ];

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function order_info()
    {
        return $this->hasOne('\App\Models\Order','id','order_id');
    }


    public static function getLists()
    {
        try {
          $query = new Self;
          $data = $query->with('order_info')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public static function getUserWalletLists($userId)
    {
        try {
          $query = new Self;
          $data = $query->where('user_id',$userId)->with('order_info')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


    public static function getWalletbalance($userId)
    {
        try {
            $query = new Self;
            $data = $query->where('user_id',$userId)->sum('amount');
            return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
