<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPayment extends Model
{
    use HasFactory;

    public $table = 'user_payments';

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'price',
        'description',
        'method',
        'status'
    ];

    public static function getLists()
    {
        try {
          $query = new Self;

            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['payment_method']) && $_GET['payment_method']!=''){
                    $query = $query->where('method',$_GET['payment_method']);
                }

                if(isset($_GET['payment_status']) && $_GET['payment_status']!=''){
                    $query = $query->where('status',$_GET['payment_status']);
                }


                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                $data = $query->with('user')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));

            }else{
                $data = $query->with('user')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
            }


         
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
