<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAuthLogin extends Model
{
    use HasFactory;

    public $table = 'user_auth_logins';

    public function user(){
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'api_token',
        'player_id',
        'fcm_token',
        'device_type'
    ];
}
