<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;
class User extends Authenticatable
{

    use HasFactory, Notifiable, HasRoles;
     use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'image',
        'status',
        'type',
        'phone',
        'role_id',
        'fcm_token',
        'country_code'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function role()
    {
        return $this->hasOne('\App\Models\Role','id','role_id');
    }


    public static function getLists($type)
    {
        try {
            $query = new Self;

            if(isset($_GET['search'])){
                if($_GET['search']!=''){
                    $keyword = $_GET['search'];
                    $query = $query->where(function($q) use ($keyword){
                        $q->where(DB::raw('LOWER(name)'), 'like', '%'.strtolower($keyword). '%')
                        ->orWhere(DB::raw('phone'),'like','%'.strtolower($keyword). '%')
                        ->orWhere(DB::raw('email'),'like','%'.strtolower($keyword). '%');
                    });
                }

                if(isset($_GET['status']) && $_GET['status']!=''){
                    if($_GET['status'] == 'active'){
                    $status = 1;
                    }else{
                    $status = 0;
                    }
                    $query = $query->where('status',$status);
                }
            }
            $data = $query->where('type',$type)->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));

            foreach ($data as $row) {
                $row->wallet_amount = UserWallet::getWalletbalance($row->id);
            }
            return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public function userWallet()
    {
        return $this->hasMany(\App\Models\UserWallet::class, 'user_id');
    }

    public function routeNotificationForFcm()
    {
        return $this->fcm_token; // Replace with your actual FCM token field
    }

    /**
    * Fetch list of subadmin from here
    **/
    public static function getSubadminList($search){
        try
        {
            $obj = new self;
            $pagination = (isset($search['perpage']))?$search['perpage']:config('constant.pagination');
            if(isset($search['search']) && !empty($search['search']))
            {
                $keyword = $_GET['search'];
                $obj = $obj->where(function($q) use ($keyword){
                    $q->where(DB::raw('LOWER(name)'), 'like', '%'.strtolower($keyword). '%')
                    ->orWhere(DB::raw('email'),'like','%'.strtolower($keyword). '%');
                });
            }
            if(isset($_GET['status']) && $_GET['status']!=''){
                if($_GET['status'] == 'active'){
                $status = 1;
                }else{
                $status = 0;
                }
                $obj = $obj->where('status',$status);
            }

            $data = $obj->where('type','subadmin')->with('role')->latest('created_at')->paginate($pagination)->appends('perpage', $pagination);
            return $data;
        }
        catch (\Exception $e)
        {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    /* for notification multiple token */
    public function routeNotificationFor($channel)
    {
        if ($channel === 'fcm') {
            // Return an array of tokens
            return json_decode($this->fcm_token, true) ?? [];
        }

        return null;
    }


}
