<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Timeslots extends Model
{
    use HasFactory;
    use SoftDeletes;

    public $table = 'timeslots';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'from_time',
        'to_time',
        'status'
    ];

    public function translation()
    {
        return $this->hasOne(TimeslotsTranslation::class, 'timeslot_id')
            ->where('lang_code', app()->getLocale());
    }


    public function getNameAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->name ?? $value;
        }

        return $this->translation->name ?? $value;
    }


}
