<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class State extends Model
{
    use HasFactory;

    public $fillable = [
        'state_name',
        'status',
    ];
    
    
    public function deliveryAreas()
    {
        return $this->hasMany(DeliveryAreas::class, 'state_id', 'id');
    }

    public static function getLists()
    {
        try {
          $query = new Self;

            if(isset($_GET['search']) && $_GET['search']!=''){
                $keyword = $_GET['search'];
                $query = $query->where(function($q) use ($keyword){
                    $q->where(DB::raw('LOWER(state_name)'), 'like', '%'.strtolower($keyword). '%');
                });
            }

            if(isset($_GET['status']) && $_GET['status']!=''){
                if($_GET['status'] == 'active'){
                $status = 1;
                }else{
                $status = 0;
                }
                $query = $query->where('status',$status);
            }

          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


}
