<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;


class Product extends Model
{
    use HasFactory;
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'image',
        'price',
        'discount_price',
        'stock',
        'description',
        'minimum_order_quantity',
        'status'
    ];

    public function translation()
    {
        return $this->hasOne(ProductTranslation::class, 'product_id')
            ->where('lang_code', app()->getLocale());
    }


    // Define the relationship with Image
    public function images()
    {
        return $this->hasMany(ProductImage::class, 'product_id', 'id');
    }


    public function getNameAttribute($value)
    {
        // Check if translation relationship is loaded and available
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->name ?? $value;
        }

        // Fallback to original value from products table
        return $value;
    }

    public function getDescriptionAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->description ?? $value;
        }

        // Even if not preloaded, try to access translation directly
        $translation = $this->translation;
        return $translation ? ($translation->description ?? $value) : $value;
    }




    public static function getLists()
    {
        try {
            $query = new self;
            $query = $query->with('translation');

            if(isset($_GET['product_id']) && $_GET['product_id']!=''){
                $query = $query->where('id',$_GET['product_id']);
            }

            if(isset($_GET['search']) && $_GET['search']!=''){
                $keyword = $_GET['search'];
                $query = $query->where(function($q) use ($keyword){
                    $q->where(DB::raw('LOWER(name)'), 'like', '%'.strtolower($keyword). '%');
                });
            }

            if(isset($_GET['status']) && $_GET['status']!=''){
                if($_GET['status'] == 'active'){
                $status = 1;
                }else{
                $status = 0;
                }
                $query = $query->where('status',$status);
            }

            if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                $parts = explode(' to ' , $_GET['date_filter']);
                $date_from = trim($parts[0]);
                $date_to = trim($parts[1]);
                $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
            }

            $query = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));

          return $query;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
