<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Partners extends Model
{
    use HasFactory;

    public $table = 'partners';

    public $fillable = [
        'type',
        'name',
        'image',
        'status'
    ];


    public function translation()
    {
        return $this->hasOne(PartnersTranslation::class, 'partner_id')
            ->where('lang_code', app()->getLocale());
    }


    public function getNameAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->name ?? $value;
        }

        return $this->translation->name ?? $value;
    }

    public static function getLists()
    {
        try {
          $query = new Self;
          $query = $query->with('translation');

           if(isset($_GET['status']) && $_GET['status']!=''){
                $status = $_GET['status'];
                $query = $query->where('type',$status);
            }

          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
