<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Exports\OrdersExport;
use Maatwebsite\Excel\Facades\Excel;

class OrderProductsDelivery extends Model
{
    use HasFactory;

    public $table = 'orders_products_delivery';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'user_id',
        'order_status_id',
        'order_id',
        'product_order_id',
        'delivery_date',
        'product_id'
    ];

    public function product_orders()
    {
        return $this->hasOne('\App\Models\OrderProduct','id','product_order_id')->with('product');
    }

    public function delivery_status()
    {
        return $this->hasOne('\App\Models\OrderStatus','id','order_status_id');
    }

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function driver()
    {
        return $this->hasOne('\App\Models\User','id','driver_id');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id')->with('delivery_address');
    }

    public static function getLists($search)
    {
        try {
            $query = new Self;
            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['driver_id']) && $_GET['driver_id']!=''){
                    $query = $query->where('driver_id',$_GET['driver_id']);
                }

                if(isset($_GET['product_order_id']) && $_GET['product_order_id']!=''){
                    $query = $query->where('product_order_id',$_GET['product_order_id']);
                }

                if(isset($_GET['order_delivery_date']) && $_GET['order_delivery_date']!=''){
                    $query = $query->where('delivery_date', date('Y-m-d',strtotime($_GET['order_delivery_date'])));
                }

                if(isset($_GET['order_status_id']) && $_GET['order_status_id']!=''){
                    $query = $query->where('order_status_id',$_GET['order_status_id']);
                }

                if(isset($_GET['order_id']) && $_GET['order_id']!=''){
                    $query = $query->where('order_id',$_GET['order_id']);
                }

                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                return $query->with("user")->with("delivery_status")->with('product_orders')->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('user')->where('delivery_date', date('Y-m-d'))->with('delivery_status')->with('product_orders')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public static function getReport($search)
    {
        try {
            $query = new Self;

            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['driver_id']) && $_GET['driver_id']!=''){
                    $query = $query->where('driver_id',$_GET['driver_id']);
                }


                if(isset($_GET['product_order_id']) && $_GET['product_order_id']!=''){
                    $query = $query->where('product_order_id',$_GET['product_order_id']);
                }

                if(isset($_GET['order_delivery_date']) && $_GET['order_delivery_date']!=''){
                    $parts = explode(' to ' , $_GET['order_delivery_date']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1] ?? null);
                    $obj = $query->where('delivery_date', '>=',date('Y-m-d',strtotime($date_from)))->where('delivery_date', '<=',date('Y-m-d',strtotime($date_to)));
                }

                if(isset($_GET['order_status_id']) && $_GET['order_status_id']!=''){
                    $query = $query->where('order_status_id',$_GET['order_status_id']);
                }

                if(isset($_GET['order_id']) && $_GET['order_id']!=''){
                    $query = $query->where('order_id',$_GET['order_id']);
                }

                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0] ?? null);
                    $date_to = trim($parts[1] ?? null);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                return $query->with("user")->with("delivery_status")->with('product_orders')->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('user')->with('delivery_status')->with('product_orders')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


    public static function getRevenueReportToExcel()
    {
        try {
            $result = self::select(
                'orders_products_delivery.id',
                'user_info.name as user_name',
                'user_info.email as user_email',
                'user_info.phone as user_phone',
                'orders.id as order_id',
                'orders_products.id as order_product_id',
                'orders_products.quantity as order_product_quantity',
                'orders_products.total_delivery_amount as order_product_total_delivery_amount',
                'driver_info.name as driver_name',
                'products.name as product_name',
                'orders_products_delivery.delivery_date',
                'order_statuses.status as order_status',
            )
                ->join('users as user_info', 'orders_products_delivery.user_id', '=', 'user_info.id')
                ->join('orders', 'orders_products_delivery.order_id', '=', 'orders.id')
                ->join('orders_products', 'orders_products_delivery.product_order_id', '=', 'orders_products.id')
                ->join('users as driver_info', 'orders_products_delivery.driver_id', '=', 'driver_info.id')
                ->join('products', 'orders_products_delivery.product_id', '=', 'products.id')
                ->join('order_statuses', 'orders_products_delivery.order_status_id', '=', 'order_statuses.id')
                ->orderBy('orders_products_delivery.id', 'asc')
                ->get();

            // Check if there are results
            if ($result) {
                return $result;
            } else {
                return collect(['status' => true, 'message' => 'No records found.']);
            }
        } catch (\Exception $e) {
            return collect(['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()]);
        }
    }

    public static function getRevenueReportToPdf()
    {
        try {
            $result = self::select(
                'orders_products_delivery.id',
                'user_info.name as user_name',
                'user_info.email as user_email',
                'user_info.phone as user_phone',
                'orders.id as order_id',
                'orders_products.id as order_product_id',
                'orders_products.quantity as order_product_quantity',
                'orders_products.total_delivery_amount as order_product_total_delivery_amount',
                'driver_info.name as driver_name',
                'products.name as product_name',
                'orders_products_delivery.delivery_date',
                'order_statuses.status as order_status',
            )
                ->join('users as user_info', 'orders_products_delivery.user_id', '=', 'user_info.id')
                ->join('orders', 'orders_products_delivery.order_id', '=', 'orders.id')
                ->join('orders_products', 'orders_products_delivery.product_order_id', '=', 'orders_products.id')
                ->join('users as driver_info', 'orders_products_delivery.driver_id', '=', 'driver_info.id')
                ->join('products', 'orders_products_delivery.product_id', '=', 'products.id')
                ->join('order_statuses', 'orders_products_delivery.order_status_id', '=', 'order_statuses.id')
                ->orderBy('orders_products_delivery.id', 'asc')
                ->get();

            // Check if there are results
            if ($result) {
                return $result;
            } else {
                return collect(['status' => true, 'message' => 'No records found.']);
            }
        } catch (\Exception $e) {
            return collect(['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()]);
        }
    }



}
