<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProduct extends Model
{
    use HasFactory;

    public $table = 'orders_products';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_id',
        'order_id',
        'price',
        'quantity',
        'total_price',
        'order_frequency'
    ];

    public function product()
    {
        return $this->hasOne('\App\Models\Product','id','product_id')->withTrashed();
    }

    public function product_deliverys()
    {
        return $this->hasMany('\App\Models\OrderProductsDelivery','product_order_id','id')->with('delivery_status');
    }

    public function product_delivery()
    {

        return $this->hasOne('\App\Models\OrderProductsDelivery', 'product_order_id', 'id')->with('delivery_status');
    }

    public function product_deliverys_status()
    {
        return $this->hasMany('\App\Models\OrderProductsDelivery','product_order_id','id')->select('id','product_order_id','order_status_id')->with('delivery_status');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id');
    }

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public static function getActiveSubscrpition($search){
        try {
            $query = new Self;


                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['product_id']) && $_GET['product_id']!=''){
                    $query = $query->where('product_id',$_GET['product_id']);
                }

                if(isset($_GET['order_frequency']) && $_GET['order_frequency']!=''){
                    $query = $query->where('order_frequency',$_GET['order_frequency']);
                }

                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                $query = $query->with("user")->with('product')->with('product_deliverys')->with('order')->where('end_date',">=",date("Y-m-d"))->where('order_frequency','!=','once')->paginate(config('constant.paginate.num_per_page'));

            return $query;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
