<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class OrderCancelRequest extends Model
{
    use HasFactory;

    public $table = 'order_cancel_request';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'user_id',
        'order_id',
        'refund_amount',
        'refund_status',
        'status'
    ];

    public static function getLists()
    {
        try {
            $query = new Self;
            $orderIdArr = array();

            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }
    
                if(isset($_GET['status']) && $_GET['status']!=''){
                    $query = $query->where('status',$_GET['status']);
                }

                

                if(isset($_GET['payment_method']) && $_GET['payment_method']!=''){

                $payment_method = $_GET['payment_method'];

                if( $payment_method == 'cash'){
                $orders = DB::table('orders')->where('payment_method','cash')->get();
                }else{
                $orders = DB::table('orders')->where('payment_method','!=','cash')->get();
                }

                
                if(count($orders)){
                    foreach($orders as $order){
                        array_push($orderIdArr,$order->id);
                    }
                }


                }


                if(isset($_GET['order_id']) && $_GET['order_id']!=''){
                    $query = $query->where('order_id',$_GET['order_id']);
                }

                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                if(count($orderIdArr) > 0){
                   $query = $query->whereIn('order_id',$orderIdArr);
                }

                return $query->with("order")->with("user")->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('order')->with('user')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id');
    }
}
