<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Order extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'user_id',
        'order_status_id',
        'delivery_address_id',
        'payment_id',
        'tax',
        'subtotal',
        'final_amount',
        'delivery_fee',
        'promotional_disount',
        'is_coupon_applied',
        'coupon_code',
        'payment_method',
        'timeslot_id'
    ];

    public static function getLists()
    {
        try {
            $query = new Self;
            $paymentIdArr = array();
            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['order_status_id']) && $_GET['order_status_id']!=''){
                    $query = $query->where('order_status_id',$_GET['order_status_id']);
                }

                if(isset($_GET['payment_method']) && $_GET['payment_method']!=''){
                    $query = $query->where('payment_method',$_GET['payment_method']);
                }

                if(isset($_GET['payment_status']) && $_GET['payment_status']!=''){

                $payment_status = $_GET['payment_status'];

                $user_payments = DB::table('user_payments')->where('status',$payment_status)->get();

                if(count($user_payments)){
                    foreach($user_payments as $user_payment){
                        array_push($paymentIdArr,$user_payment->id);
                    }
                }


                }

                if(isset($_GET['order_id']) && $_GET['order_id']!=''){
                    $query = $query->where('id',$_GET['order_id']);
                }

                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $query = $query->where('created_at', '>=',date('Y-m-d',strtotime($date_from)))->where('created_at', '<=',date('Y-m-d',strtotime($date_to)));
                }

                if(count($paymentIdArr) > 0){
                   $query = $query->whereIn('payment_id',$paymentIdArr);
                }


                return $query->with("user")->with("order_status")->with('payment')->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('user')->with('order_status')->with('payment')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public static function getLatest()
    {
        try {
            $query = new Self;
            return $query->with("user")->with("order_status")->with('payment')->orderBy("id","DESC")->take(10)->get();
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public static function getExportData()
{
        try {
            return self::select(
                'orders.id',
                'users.name as user_name',
                'users.email as user_email',
                'order_statuses.status as order_status',
                'delivery_addresses.google_address as delivery_address',
                'user_payments.status as payment_status',
                'orders.subtotal',
                'orders.final_amount',
                'orders.tax',
                'orders.payment_method',
                'timeslots.name as timeslot_name',
            )
                ->join('users', 'orders.user_id', '=', 'users.id')
                ->join('order_statuses', 'orders.order_status_id', '=', 'order_statuses.id')
                ->join('delivery_addresses', 'orders.delivery_address_id', '=', 'delivery_addresses.id')
                ->leftJoin('user_payments', 'orders.payment_id', '=', 'user_payments.id')
                ->leftJoin('timeslots', 'orders.timeslot_id', '=', 'timeslots.id')
                ->with('payment')
                ->orderBy('orders.id', 'asc') //change its orders sorting from here
                ->get(); // Use get() instead of paginate()
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()];
        }
}


    public static function getExportDataToPdf()
{

         return self::select(
                'orders.id',
                'users.name as user_name',
                'users.phone as user_phone',
                'order_statuses.status as order_status',
                'delivery_addresses.google_address as delivery_address',
                'user_payments.status as payment_status',
                'orders.promotional_disount',
                'orders.is_coupon_applied',
                'orders.coupon_code',
                'orders.subtotal',
                'orders.final_amount',
                'orders.tax',
                'orders.delivery_fee',
                'orders.payment_method',
                'timeslots.name as timeslot_name',
                'orders.created_at',
                'orders.updated_at'
            )
            ->leftJoin('users', 'orders.user_id', '=', 'users.id')
            ->leftJoin('order_statuses', 'orders.order_status_id', '=', 'order_statuses.id')
            ->leftJoin('delivery_addresses', 'orders.delivery_address_id', '=', 'delivery_addresses.id')
            ->leftJoin('timeslots', 'orders.timeslot_id', '=', 'timeslots.id')
            ->leftJoin('user_payments', 'orders.payment_id', '=', 'user_payments.id') // Add this leftJoin for user_payments
            ->with(['user', 'payment', 'time_slots'])
            ->orderBy('orders.id', 'asc')
            ->get();
            /* ->paginate(config('constant.paginate.num_per_page')); */
}


    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id')->with('userWallet');
    }

    public function userOnly()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function order_status()
    {
        return $this->hasOne('\App\Models\OrderStatus','id','order_status_id');
    }

    public function product_orders()
    {
        return $this->hasMany('\App\Models\OrderProduct','order_id','id')->with('product')->with('product_deliverys');
    }

    public function product_orders_driver()
    {
        return $this->hasMany('\App\Models\OrderProduct','order_id','id')->with('product')->with('product_delivery');

    }

    public function payment()
    {
        return $this->hasOne('\App\Models\UserPayment','id','payment_id');
    }

    public function delivery_address()
    {
        return $this->hasOne('\App\Models\DeliveryAddresses','id','delivery_address_id');
    }

    public function time_slots()
    {
        return $this->hasOne('\App\Models\Timeslots','id','timeslot_id');
    }

    public function cancel_request()
    {
        return $this->hasOne('\App\Models\OrderCancelRequest','order_id','id');
    }
}
