<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeliveryAddresses extends Model
{
    use HasFactory;

    public $table = 'delivery_addresses';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'type',
        'address',
        'location_name',
        'google_address',
        'note',
        'city',
        'state',
        'country',
        'zipcode',
        'latitude',
        'longitude',
        'is_default'
    ];
    
    
    public static function getLists($userId)
    {
        try {
          $query = new Self;
          $query = $query->where('user_id',$userId)->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $query;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
