<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Currencies extends Model
{
    use HasFactory;

    public $table = 'currencies';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'symbol',
        'code',
        'decimal_digits',
        'rounding',
        'status',
        'is_default'
    ];

    public static function getLists()
    {
        try {
          $query = new Self;
          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
