<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Coupon extends Model
{
    use HasFactory;

    public $fillable = [
        'coupon_name',
        'type',
        'value',
        'start_date',
        'end_date',        
        'minimum_order_value',
        'image',
        'status',
        'description'
    ];

    public function translation()
    {
        return $this->hasOne(CouponTranslation::class, 'coupon_id')
            ->where('lang_code', app()->getLocale());
    }

    public function getCouponNameAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->coupon_name ?? $value;
        }

        return $this->translation->coupon_name ?? $value;
    }

    public function getDescriptionAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->description ?? $value;
        }

        return $this->translation->description ?? $value;
    }



    public static function getLists()
    {
        try {
            $query = new Self;
            $query = $query->with('translation');

            if(isset($_GET['search']) && $_GET['search']!='') {
                $keyword = $_GET['search'];
                $query = $query->where(DB::raw('LOWER(coupon_name)'), 'like', '%'.strtolower($keyword).'%');
            }
      
            if(isset($_GET['status']) && $_GET['status']!=''){
                    if($_GET['status'] == 'active'){
                    $status = 1;
                    }else{
                    $status = 0;
                    }
                    $query = $query->where('status',$status);
            }

            if(isset($_GET['type']) && $_GET['type']!=''){
                $type = $_GET['type'];
                    $query = $query->where('type',$type);
            }

            $data = $query->orderBy('status', 'DESC')->paginate(config('constant.paginate.num_per_page'));

          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
