<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Contactus extends Model
{
    use HasFactory;

    public $table = 'contactus';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'email',
        'name',
        'mobile',
        'message'
    ];

    public static function getLists()
    {
        try {
          $query = new Self;

            if(isset($_GET['search'])){
                if($_GET['search']!=''){
                    $keyword = $_GET['search'];
                    $query = $query->where(function($q) use ($keyword){
                        $q->where(DB::raw('LOWER(name)'), 'like', '%'.strtolower($keyword). '%')
                        ->orWhere(DB::raw('mobile'),'like','%'.strtolower($keyword). '%')
                        ->orWhere(DB::raw('email'),'like','%'.strtolower($keyword). '%');
                    });
                }

                if(isset($_GET['status']) && $_GET['status']!=''){
                    if($_GET['status'] == 'replied'){
                    $status = 1;
                    }else{
                    $status = 0;
                    }
                    $query = $query->where('is_replied',$status);
                }
            }

          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
