<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CmsPages extends Model
{
    use HasFactory;

    public $table = 'cms_contents';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'page_name',
        'page_title',
        'description',
        'status'
    ];

    public function translation()
    {
        return $this->hasOne(CmsPagesTranslation::class, 'cms_id')
            ->where('lang_code', app()->getLocale());
    }


    public function getPageTitleAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->page_title ?? $value;
        }

        return $this->translation->page_title ?? $value;
    }

    public function getDescriptionAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->description ?? $value;
        }

        return $this->translation->description ?? $value;
    }


}
