<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class City extends Model
{
    use HasFactory;

    public $fillable = [
        'state_id',
        'city_name',
        'status',
    ];
    
    
    /**
     * Get the state that owns the city.
     */
    public function state()
    {
        return $this->belongsTo(State::class, 'state_id', 'id');
    }
    
    public function deliveryAreas()
    {
        return $this->hasMany(DeliveryArea::class, 'city_id', 'id');
    }

    public static function getLists()
    {
        try {
          $query = new Self;

            if(isset($_GET['search']) && $_GET['search']!=''){
                $keyword = $_GET['search'];
                $query = $query->where(function($q) use ($keyword){
                    $q->where(DB::raw('LOWER(city_name)'), 'like', '%'.strtolower($keyword). '%');
                });
            }
            
            
            if(isset($_GET['state_id']) && $_GET['state_id']!=''){
                $state_id = $_GET['state_id'];
                $query = $query->where('state_id',$state_id);
            }

            if(isset($_GET['status']) && $_GET['status']!=''){
                if($_GET['status'] == 'active'){
                $status = 1;
                }else{
                $status = 0;
                }
                $query = $query->where('status',$status);
            }

          $data = $query->orderBy('id','DESC')->with('state')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


}