<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Banners extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'sub_title',
        'image',
        'status',
        'banner_type'
    ];


    public function translation()
    {
        return $this->hasOne(BannerTranslation::class, 'banner_id')
            ->where('lang_code', app()->getLocale());
    }


    public function getTitleAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->title ?? $value;
        }

        return $this->translation->title ?? $value;
    }

    public function getSubTitleAttribute($value)
    {
        if ($this->relationLoaded('translation') && $this->translation) {
            return $this->translation->sub_title ?? $value;
        }

        return $this->translation->sub_title ?? $value;
    }



    public static function getLists()
    {
        try {
            $query = new Self;
            $query = $query->with('translation');

            if(isset($_GET['search']) && $_GET['search']!='') {
                $keyword = $_GET['search'];
                $query = $query->where(DB::raw('LOWER(title)'), 'like', '%'.strtolower($keyword).'%');
            }
       
            if(isset($_GET['status']) && $_GET['status']!=''){
                    if($_GET['status'] == 'active'){
                    $status = 1;
                    }else{
                    $status = 0;
                    }
                    $query = $query->where('status',$status);
            }

            if(isset($_GET['type']) && $_GET['type']!=''){
                $banner_type = $_GET['type'];
                    $query = $query->where('banner_type',$banner_type);
            }

          $query = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $query;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
