<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppSetting extends Model
{
    use HasFactory;

    public $table = 'app_settings';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value'
    ];

    static function get_setting($setting_name, $default=0){
       $data= self::select(['value'])->where('key',$setting_name)->first();
       return $data ? $data->value : $default;
    }
    static function save_setting(string $setting_name, $setting_value) {
        // Check if the setting_value is null and retrieve existing data
        $data = self::where('key', $setting_name)->first();
        $newData = ['key' => $setting_name, 'value' => $setting_value];
        if (!empty($data)) {
                $data->update(['value' => $setting_value]);
        } else {
            self::create(['key' => $setting_name, 'value' => $setting_value]);
        }

        return $newData;
    }
    static function save_setting_multiple(array $settings){
        foreach($settings as $setting){
            self::save_setting($setting['key'],$setting['value']);
        }
    }
}
